package gov.va.vinci.dart.db.impl;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.biz.RequestStatus;
import gov.va.vinci.dart.biz.RequestWorkflow;
import gov.va.vinci.dart.db.RequestWorkflowDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class RequestWorkflowDAOImpl extends HibernateDAO implements RequestWorkflowDAO {

	@Override
	public RequestWorkflow findById(final int workflowId) {
		Query q = createQuery("from RequestWorkflow where id=:wid");
		q.setParameter("wid", workflowId);
		return (RequestWorkflow)q.getSingleResult();
	}

	
	@Override
	public RequestWorkflow findOpenByRequestAndWorkflowTemplateId(final int requestId, final int workflowTemplateId) {	
		Query query = createQuery("from RequestWorkflow where request.id=:rid and workflowTemplate.id=:wtid and requestState<>:closedId");
		query.setParameter("rid", requestId);
		query.setParameter("wtid", workflowTemplateId);
		query.setParameter("closedId", RequestStatus.CLOSED.getId());
		
		try {
			RequestWorkflow result = (RequestWorkflow)query.getSingleResult();
			
//			if (result == null) {
//				throw new ObjectNotFoundException("No workflow found with template id " + workflowTemplateId + " for request id " + requestId);
//			}
			
			return result;
		} catch (NoResultException e) {
//			throw new ObjectNotFoundException("No workflow found with template id " + workflowTemplateId + " for request id " + requestId);
			return null;	//no such workflow attached to this request
		}
		
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<RequestWorkflow> listByRequestAndWorkflowTemplateId(final int requestId, final int workflowTemplateId) {	
		Query query = createQuery("from RequestWorkflow where request.id=:rid and workflowTemplate.id=:wtid");
		query.setParameter("rid", requestId);
		query.setParameter("wtid", workflowTemplateId);
		
		return (List<RequestWorkflow>)query.getResultList();
	}
	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestWorkflow> listAll() {
		Query query = createQuery("from RequestWorkflow");
		return (List<RequestWorkflow>)query.getResultList();
	}

	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestWorkflow> listByRequestId(final int requestId) {
		Query query = createQuery("from RequestWorkflow where request.id=:rid");
		query.setParameter("rid", requestId);

		return (List<RequestWorkflow>)query.getResultList();
	}
	
	
	@Override
	@SuppressWarnings("unchecked")
	public List<RequestWorkflow> listOpenByRequestId(final int requestId) {
		Query query = createQuery("from RequestWorkflow where request.id=:rid and requestState<>:closedId");
		query.setParameter("rid", requestId);
		query.setParameter("closedId", RequestStatus.CLOSED.getId());

		return (List<RequestWorkflow>)query.getResultList();
	}
	
	
	@Override
	public void save(RequestWorkflow workflow) {
		if (workflow == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(workflow);
	}

	@Override
	public void delete(RequestWorkflow workflow) {
		if (workflow == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.delete(workflow);
	}

}
